/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.data.registry.ItemRegistry;
import com.voxelutopia.ultramarine.util.RawVoxelShape;
import com.voxelutopia.ultramarine.world.block.BaseBlockProperty;
import com.voxelutopia.ultramarine.world.block.DecorativeBlock;
import com.voxelutopia.ultramarine.world.block.state.ModBlockStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class HangingLantern
extends DecorativeBlock {
    public static final IntegerProperty LANTERNS = ModBlockStateProperties.LANTERNS;
    private static final RawVoxelShape POLE_NORTH_RAW = new RawVoxelShape(7.0, -16.0, 1.0, 9.0, 32.0, 3.0);
    private static final RawVoxelShape POLE_HANGING_X_RAW = new RawVoxelShape(0.0, 28.0, 7.0, 16.0, 30.0, 9.0);
    private static final VoxelShape HANGING_INTERACTION = Block.m_49796_((double)4.0, (double)-8.0, (double)4.0, (double)12.0, (double)24.0, (double)12.0);
    private static final VoxelShape POLE_NORTH = POLE_NORTH_RAW.copy().toVoxelShape();
    private static final VoxelShape POLE_WEST = POLE_NORTH_RAW.copy().rotateY(90.0f).toVoxelShape();
    private static final VoxelShape POLE_SOUTH = POLE_NORTH_RAW.copy().rotateY(180.0f).toVoxelShape();
    private static final VoxelShape POLE_EAST = POLE_NORTH_RAW.copy().rotateY(270.0f).toVoxelShape();
    private static final VoxelShape POLE_HANGING_X = POLE_HANGING_X_RAW.copy().toVoxelShape();
    private static final VoxelShape POLE_HANGING_Z = POLE_HANGING_X_RAW.copy().rotateY(90.0f).toVoxelShape();
    private static final VoxelShape HANGING_INTERACTION_X = Shapes.m_83110_((VoxelShape)HANGING_INTERACTION, (VoxelShape)POLE_HANGING_X);
    private static final VoxelShape HANGING_INTERACTION_Z = Shapes.m_83110_((VoxelShape)HANGING_INTERACTION, (VoxelShape)POLE_HANGING_Z);
    public static final DecorativeBlock.ShapeFunction POLE_ONLY = (pState, pLevel, pPos, pContext) -> {
        RawVoxelShape POLE_NORTH_RAW = new RawVoxelShape(7.0, 0.0, 1.0, 9.0, 32.0, 3.0);
        return switch ((Direction)pState.m_61143_((Property)f_54117_)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN, Direction.UP, Direction.NORTH -> POLE_NORTH_RAW.copy().toVoxelShape();
            case Direction.WEST -> POLE_NORTH_RAW.copy().rotateY(90.0f).toVoxelShape();
            case Direction.SOUTH -> POLE_NORTH_RAW.copy().rotateY(180.0f).toVoxelShape();
            case Direction.EAST -> POLE_NORTH_RAW.copy().rotateY(270.0f).toVoxelShape();
        };
    };
    private final HangingLanternType type;

    public HangingLantern(HangingLanternType type) {
        super(DecorativeBlock.with(BaseBlockProperty.WOOD).directional().luminous());
        this.m_49959_((BlockState)((BlockState)this.stateDefinition.m_61090_()).m_61124_((Property)LANTERNS, (Comparable)Integer.valueOf(1)));
        this.type = type;
    }

    @Override
    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch (this.type) {
            case POLE: {
                return switch ((Direction)pState.m_61143_((Property)f_54117_)) {
                    default -> throw new IncompatibleClassChangeError();
                    case Direction.DOWN, Direction.UP, Direction.NORTH -> POLE_NORTH;
                    case Direction.SOUTH -> POLE_SOUTH;
                    case Direction.WEST -> POLE_WEST;
                    case Direction.EAST -> POLE_EAST;
                };
            }
            case HANGING: {
                return switch ((Direction)pState.m_61143_((Property)f_54117_)) {
                    default -> throw new IncompatibleClassChangeError();
                    case Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH -> POLE_HANGING_X;
                    case Direction.WEST, Direction.EAST -> POLE_HANGING_Z;
                };
            }
        }
        return Shapes.m_83040_();
    }

    public VoxelShape m_6079_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        switch (this.type) {
            case POLE: {
                this.m_5940_(pState, pLevel, pPos, CollisionContext.m_82749_());
                break;
            }
            case HANGING: {
                return switch ((Direction)pState.m_61143_((Property)f_54117_)) {
                    default -> throw new IncompatibleClassChangeError();
                    case Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH -> HANGING_INTERACTION_X;
                    case Direction.WEST, Direction.EAST -> HANGING_INTERACTION_Z;
                };
            }
        }
        return super.m_6079_(pState, pLevel, pPos);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack item = pPlayer.m_21120_(pHand);
        int lanterns = (Integer)pState.m_61143_((Property)LANTERNS);
        if (item.m_150930_((Item)ItemRegistry.SMALL_RED_LANTERN.get()) && lanterns < 3) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)LANTERNS, (Comparable)Integer.valueOf(lanterns + 1)), 3);
            if (!pPlayer.m_7500_()) {
                item.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
        }
        return InteractionResult.PASS;
    }

    @Override
    @NotNull
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState state = super.m_5573_(pContext);
        return (BlockState)((BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LANTERNS, (Comparable)Integer.valueOf(1));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{LANTERNS});
    }

    public static enum HangingLanternType {
        POLE,
        HANGING;

    }
}

